#ifndef MOC_H
#define MOC_H
// <<< Use Configuration Wizard in Context Menu >>>
// <h> Set MOTOR_CONT1
	// <o.0> SPFB_FILETER <0=> Disable <1=> Enable 
	// <o.5> MPWMEN <0=> Disable <1=> Enable 
	// <o.6> MPWMDUSEL <0=> From Register <1=> From SVPWM Register
	#define MOTOR_CONT1_REGS 0x61
	// </h>


// <h> Set MOTOR_CONT2
	// <o.4> SVPWMMODE <0=> 7-SVPWM <1=> 5-SVPWM 
	#define MOTOR_CONT2_REGS 0x34
// </h>

// <h> Set MOTOR_CONT3
	// <o.0> CPS_LMT_SEL <0=> Dead time compensation min duty limit is 2xdeadband <1=> Dead time compensation min duty limit is deadband
	// <o.4..5> IDQ_FB_SEL <0=> Iq/Id direct feedback <1=> Two Iq/Id value average <2=> Four Iq/Id value average
	// <o.6> SMO_CMP_VALUE <0=> Compare with MAX_SMC_ERR <1=> Compare with 0
	#define MOTOR_CONT3_REGS 0x81
// </h>

// <h> Set SVPWM_AMP 
	// <o> SVPWM_AMP <0-65535>
	#define SVPWM_AMP_REGS 0x4000
// </h>


// <h> Set FGCTRL
	// <o.7> FG_EN <0=> Disable <1=> Enable
	// <o.0..2> FGPULSE_SEL <0=> 1 pulses/cycle <1=> 2 pulses/cycle <2=> 4 pulses/cycle <3=> 8 pulses/cycle <4=> 12 pulses/cycle 
	#define FG_CTRL_REGS 0x04
// </h>


// <h> Set Estimation current ration
	//<o.4..6> ESTCR <0=> 1 Gain <1=> 2 Gain <2=> 4 Gain <3=> 8 Gain <4=> 1/2 Gain <5=> 1/4 Gain <6=> 1/8 Gain <7=> 1/16 Gain
	//<i> Estimated current ratio
	#define ESTCR_GAIN_REGS 0x00
	#if (ESTCR_GAIN_REGS == 0x00)
		#define ESTCR_GAIN (float)1
	#endif
	#if (ESTCR_GAIN_REGS == 0x10)
		#define ESTCR_GAIN (float)2
	#endif
	#if (ESTCR_GAIN_REGS == 0x20)
		#define ESTCR_GAIN (float)4
	#endif
	#if (ESTCR_GAIN_REGS == 0x30)
		#define ESTCR_GAIN (float)8
	#endif
	#if (ESTCR_GAIN_REGS == 0x40)
		#define ESTCR_GAIN (float)5000/10000
	#endif
	#if (ESTCR_GAIN_REGS == 0x50)
		#define ESTCR_GAIN (float)2500/10000 
	#endif
	#if (ESTCR_GAIN_REGS == 0x60)
		#define ESTCR_GAIN (float)1250/10000
	#endif
	#if (ESTCR_GAIN_REGS == 0x70)
		#define ESTCR_GAIN (float)625/10000
	#endif
// </h>

// <h> Set PI_GAIN 
	// <o.0> PLL KI Gain x16 <0=> Disable <1=> Enable
	// <o.1> PLL KP Gain x16 <0=> Disable <1=> Enable
	// <o.2> SPEED KI Gain x16 <0=> Disable <1=> Enable
	// <o.3> SPEED KP Gain x16 <0=> Disable <1=> Enable
	// <o.4> ID KI Gain x16 <0=> Disable <1=> Enable
	// <o.5> ID KP Gain x16 <0=> Disable <1=> Enable
	// <o.6> IQ KI Gain x16 <0=> Disable <1=> Enable
	// <o.7> IQ KP Gain x16 <0=> Disable <1=> Enable
	#define PI_GAIN_REGS 0x00
// </h>


// <<< end of configuration section >>>
#endif